﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Media;
using System.Windows;

namespace OcadMapLibrary {

	public class TextObject : MapObject {

		Rect layoutRect;
		public Rect LayoutRect {
			get {
				return layoutRect;
			}
			set {
				layoutRect = value;
			}
		}

		string text;
		public string Text {
			get {
				return text;
			}
			set {
				text = value;
			}
		}

		double rotation;
		public double Rotation {
			get {
				return rotation;
			}
			set {
				rotation = value;
			}
		}

		public override void DrawObject(DrawingContext drawingContext, List<MapSymbol> mapSymbols, MapColor mapColor) {
			TextSymbol symbol = (TextSymbol)TargetSymbol.GetMapSymbol(mapSymbols);
			if (symbol == null) {
				return;
			}
			symbol.DrawSymbol(Text, LayoutRect, Rotation, drawingContext, mapColor);
		}

		public override Rect GetBoundingRect(List<MapSymbol> mapSymbols) {
			TextSymbol symbol = (TextSymbol)TargetSymbol.GetMapSymbol(mapSymbols);
			if (symbol == null) {
				return Rect.Empty;
			}
			return symbol.GetBoundingRect(Text, LayoutRect, Rotation);
		}

	}

}
