﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Media;

namespace OcadMapLibrary {

	public class PointSymbolLine : PointSymbolElement {

		MapPathFigure data;
		public MapPathFigure Data {
			get {
				return data;
			}
			set {
				data = value;
			}
		}

		MapColorRef strokeColor;
		public MapColorRef StrokeColor {
			get {
				return strokeColor;
			}
			set {
				strokeColor = value;
			}
		}

		double strokeThickness;
		public double StrokeThickness {
			get {
				return strokeThickness;
			}
			set {
				strokeThickness = value;
			}
		}

		public override void Draw(DrawingContext drawingContext, MapColor mapColor) {
			if (StrokeColor == null) {
				return;
			}
			if (!StrokeColor.Matches(mapColor)) {
				return;
			}
			if (StrokeThickness <= 0) {
				return;
			}
			PathGeometry geometry = data.GetGeometry();
			Pen pen = new Pen(new SolidColorBrush(mapColor.Color), StrokeThickness);
			drawingContext.DrawGeometry(null, pen, geometry);
		}

		public override Rect GetBoundingRect(Point position) {
			Rect rect = Rect.Empty;
			if (StrokeThickness <= 0 || StrokeColor == null) {
				return rect;
			}
			PathGeometry geometry = data.GetGeometry();
			Pen pen = new Pen(Brushes.Black, StrokeThickness);
			rect = geometry.GetRenderBounds(pen);
			if (!rect.IsEmpty) {
				rect.Offset(position.X, position.Y);
			}
			return rect;
		}

		public override bool ContainsColor(MapColor mapColor) {
			if (StrokeColor != null && StrokeThickness > 0) {
				if (StrokeColor.Matches(mapColor)) {
					return true;
				}
			}
			return false;
		}

	}

}
