﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Media;

namespace OcadMapLibrary {

	public class PointSymbolFilledEllipse : PointSymbolElement {

		Point center;
		public Point Center {
			get {
				return center;
			}
			set {
				center = value;
			}
		}

		double radius;
		public double Radius {
			get {
				return radius;
			}
			set {
				radius = value;
			}
		}

		MapColorRef fillColor;
		public MapColorRef FillColor {
			get {
				return fillColor;
			}
			set {
				fillColor = value;
			}
		}

		public override void Draw(DrawingContext drawingContext, MapColor mapColor) {
			if (FillColor == null) {
				return;
			}
			if (!FillColor.Matches(mapColor)) {
				return;
			}
			drawingContext.DrawEllipse(new SolidColorBrush(mapColor.Color), null, Center, radius, radius);
		}

		public override Rect GetBoundingRect(Point position) {
			Rect rect = Rect.Empty;
			if (FillColor == null) {
				return rect;
			}
			rect = new Rect(-radius, -radius, radius * 2, radius * 2);
			if (!rect.IsEmpty) {
				rect.Offset(position.X, position.Y);
			}
			return rect;
		}

		public override bool ContainsColor(MapColor mapColor) {
			if (FillColor != null) {
				if (FillColor.Matches(mapColor)) {
					return true;
				}
			}
			return false;
		}

	}

}
