﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Media;

namespace OcadMapLibrary {

	public class PointSymbolEllipse : PointSymbolElement {

		Point center;
		public Point Center {
			get {
				return center;
			}
			set {
				center = value;
			}
		}

		double radius;
		public double Radius {
			get {
				return radius;
			}
			set {
				radius = value;
			}
		}

		MapColorRef strokeColor;
		public MapColorRef StrokeColor {
			get {
				return strokeColor;
			}
			set {
				strokeColor = value;
			}
		}

		double strokeThickness;
		public double StrokeThickness {
			get {
				return strokeThickness;
			}
			set {
				strokeThickness = value;
			}
		}

		public override void Draw(DrawingContext drawingContext, MapColor mapColor) {
			if (StrokeColor == null) {
				return;
			}
			if (!StrokeColor.Matches(mapColor)) {
				return;
			}
			if (StrokeThickness <= 0) {
				return;
			}
			Pen pen = new Pen(new SolidColorBrush(mapColor.Color), StrokeThickness);
			drawingContext.DrawEllipse(null, pen, Center, radius, radius);
		}

		public override Rect GetBoundingRect(Point position) {
			Rect rect = Rect.Empty;
			if (StrokeThickness <= 0 || StrokeColor == null) {
				return rect;
			}
			double fullRadius = radius + StrokeThickness / 2;
			rect = new Rect(-fullRadius, -fullRadius, fullRadius * 2, fullRadius * 2);
			if (!rect.IsEmpty) {
				rect.Offset(position.X, position.Y);
			}
			return rect;
		}

		public override bool ContainsColor(MapColor mapColor) {
			if (StrokeColor != null && StrokeThickness > 0) {
				if (StrokeColor.Matches(mapColor)) {
					return true;
				}
			}
			return false;
		}

	}

}
