﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Media;

namespace OcadMapLibrary {

	public class MapStroke {

		public MapStroke() {
			lineJoinStyle = PenLineJoin.Bevel;
		}

		double thickness;
		public double Thickness {
			get {
				return thickness;
			}
			set {
				thickness = value;
			}
		}

		MapColorRef color;
		public MapColorRef Color {
			get {
				return color;
			}
			set {
				color = value;
			}
		}

		PenLineJoin lineJoinStyle;
		public PenLineJoin LineJoinStyle {
			get {
				return lineJoinStyle;
			}
			set {
				lineJoinStyle = value;
			}
		}

		public bool MatchesColor(MapColor mapColor) {
			if (Color == null) {
				return false;
			}
			return Color.Matches(mapColor);
		}

		Pen GetPen(MapColor mapColor) {
			Pen pen = new Pen(new SolidColorBrush(mapColor.Color), Thickness);
			pen.LineJoin = LineJoinStyle;
			if (LineJoinStyle == PenLineJoin.Round) {
				pen.StartLineCap = PenLineCap.Round;
				pen.EndLineCap = PenLineCap.Round;
			} else {
				pen.StartLineCap = PenLineCap.Flat;
				pen.EndLineCap = PenLineCap.Flat;
			}
			return pen;
		}

		public void DrawGeometry(Geometry geometry, DrawingContext drawingContext, MapColor mapColor) {
			if (!MatchesColor(mapColor) || Thickness <= 0) {
				return;
			}
			Pen pen = GetPen(mapColor);
			drawingContext.DrawGeometry(null, pen, geometry);
		}

		public void DrawGeometryWithDashes(Geometry geometry, DoubleCollection dashes, double dashOffset, DrawingContext drawingContext, MapColor mapColor) {
			if (!MatchesColor(mapColor) || Thickness <= 0) {
				return;
			}
			Pen pen = GetPen(mapColor);
			pen.DashCap = PenLineCap.Flat;
			DashStyle dashStyle = new DashStyle();
			pen.DashStyle = dashStyle;
			DoubleCollection newDashes = dashes.Clone();
			for (int i = 0; i < newDashes.Count; i++) {
				newDashes[i] /= Thickness;
			}
			dashStyle.Dashes = newDashes;
			dashStyle.Offset = dashOffset / Thickness;
			drawingContext.DrawGeometry(null, pen, geometry);
		}

	}

}
