﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace OPlanner {

	public partial class NewCourseObject : Window {

		public NewCourseObject() {
			InitializeComponent();
		}

		private Course course;
		private OCurrentInfo info;

		public void SetInfo(OCurrentInfo newInfo) {
			info = newInfo;
		}

		public void SetCourse(Course newCourse) {
			course = newCourse;
		}

		public Course GetCourse() {
			return course;
		}

		private void addButton_Click(object sender, RoutedEventArgs e) {
			if (newObjectBox.SelectedIndex <= 0) {
				return;
			}
			if (course == null) {
				return;
			}
			TextValueComboBoxItem item = (TextValueComboBoxItem)newObjectBox.SelectedItem;
			if (item.Value == "TextDescription") {
				OTextDescription obj = new OTextDescription(course);
				obj.ObjectCode = obj.ObjectCodePrefix + Convert.ToString(course.GetNextCodeNum(typeof(OTextDescription)));
				course.AddOrderedObject(obj);
				info.SelectedObjects.Clear();
				info.SelectedObjects.Add(obj);
				info.InvokeObjectsCreated(this);
				info.InvokeObjectsSelected(this);
			}
			Close();
		}

		private void cancelButton_Click(object sender, RoutedEventArgs e) {
			Close();
		}

	}
}
