﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace OPlanner {
	
	public partial class MapInfoWindow : Window {

		public MapInfoWindow() {
			InitializeComponent();
		}

		private OCurrentInfo info;

		public void SetInfo(OCurrentInfo newInfo) {
			info = newInfo;
			Update();
		}

		private void Update() {
			string mapTypeString = "Unknown";
			if (info.Data.MapInfo.MapType == MapFileType.None) {
				mapTypeString = "None";
			}else if(info.Data.MapInfo.MapType == MapFileType.Image) {
				mapTypeString = "Image";
			} else if (info.Data.MapInfo.MapType == MapFileType.Xaml) {
				mapTypeString = "Xaml";
			} else if (info.Data.MapInfo.MapType == MapFileType.Xps) {
				mapTypeString = "Xps";
			} else if (info.Data.MapInfo.MapType == MapFileType.Ocad) {
				mapTypeString = "Ocad";
			}
			mapTypeLabel.Content = mapTypeString;
			if (info.Data.MapInfo.OcadVersionString == "") {
				ocadVersionPanel.Visibility = Visibility.Collapsed;
			} else {
				ocadVersionLabel.Content = info.Data.MapInfo.OcadVersionString;
			}
			if (info.Data.MapInfo.DefaultScaleString == "") {
				defaultScalePanel.Visibility = Visibility.Collapsed;
			} else {
				defaultScaleLabel.Content = info.Data.MapInfo.DefaultScaleString;
			}
		}

		private void okButton_Click(object sender, RoutedEventArgs e) {
			Close();
		}

	}

}
