﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace OPlanner {

	public delegate void DescriptionSelectedEventHandler(string code, int column);
	public delegate void FeatureSizeSetEventHandler(double x, double y);

	public partial class DescriptionsHeader : UserControl {

		public static DependencyProperty ColumnProperty;

		static DescriptionsHeader() {
			ColumnProperty = DependencyProperty.Register("Column", typeof(int), typeof(DescriptionsHeader));
		}

		public DescriptionsHeader() {
			InitializeComponent();
			featureSize = new Size(0, 0);
		}

		public int Column {
			get {
				return (int)base.GetValue(ColumnProperty);
			}
			set {
				base.SetValue(ColumnProperty, value);
			}
		}

		public event DescriptionSelectedEventHandler DescriptionSelected;
		public event FeatureSizeSetEventHandler FeatureSizeSet;

		private TextBox xBox;
		private TextBox yBox;
		private Size featureSize;

		public Size GetFeatureSize() {
			return featureSize;
		}

		public void SetFeatureSize(double x, double y) {
			featureSize.Width = x;
			featureSize.Height = y;
			if (xBox != null) {
				if (x == 0) {
					xBox.Text = "";
				} else {
					xBox.Text = x.ToString();
				}
			}
			if (yBox != null) {
				if (y == 0) {
					yBox.Text = "";
				} else {
					yBox.Text = y.ToString();
				}
			}
		}

		public void LoadDescriptions(DescriptionManager descriptionManager) {
			mainPanel.Children.Clear();
			ToolTip toolTip;
			if (descriptionManager != null) {
				List<DescriptionSymbol> symbols;
				Panel panel;
				symbols = descriptionManager.GetSymbols(Column);
				panel = mainPanel;
				for (int i = 0; i < symbols.Count; i++) {
					DescriptionSymbolButton bt = new DescriptionSymbolButton();
					bt.Template = (ControlTemplate)FindResource("DescriptionButtonTemplate");
					bt.Content = symbols[i].GetSymbol(OPlannerDefaults.DescriptionSize, Brushes.Black);
					bt.Column = Column;
					bt.SymbolCode = symbols[i].SymbolCode;
					bt.Click += new RoutedEventHandler(DescriptionButtonClick);
					if (symbols[i].Text != null && symbols[i].Text != "") {
						toolTip = new ToolTip();
						toolTip.Content = symbols[i].Text;
						bt.ToolTip = toolTip;
					}
					panel.Children.Add(bt);
				}
			}
			DescriptionSymbolButton blank = new DescriptionSymbolButton();
			blank.Template = (ControlTemplate)FindResource("DescriptionButtonTemplate");
			blank.Column = Column;
			blank.SymbolCode = "";
			blank.Click += new RoutedEventHandler(DescriptionButtonClick);
			Border border = new Border();
			border.Width = OPlannerDefaults.DescriptionSize;
			border.Height = OPlannerDefaults.DescriptionSize;
			border.BorderBrush = Brushes.Black;
			border.BorderThickness = new Thickness(1);
			blank.Content = border;
			toolTip = new ToolTip();
			toolTip.Content = "None";
			blank.ToolTip = toolTip;
			mainPanel.Children.Add(blank);
			if (Column == 6) {
				StackPanel sizePanel = new StackPanel();
				sizePanel.Orientation = Orientation.Horizontal;
				TextBlock textBlock = new TextBlock();
				textBlock.Text = "Feature Size:";
				textBlock.VerticalAlignment = VerticalAlignment.Center;
				sizePanel.Children.Add(textBlock);
				xBox = new TextBox();
				xBox.Width = 30;
				xBox.VerticalAlignment = VerticalAlignment.Center;
				xBox.Margin = new Thickness(5, 0, 0, 3);
				xBox.LostKeyboardFocus += new KeyboardFocusChangedEventHandler(FeatureSizeLostFocus);
				sizePanel.Children.Add(xBox);
				yBox = new TextBox();
				yBox.Width = 30;
				yBox.VerticalAlignment = VerticalAlignment.Center;
				yBox.Margin = new Thickness(5, 0, 5, 3);
				yBox.LostKeyboardFocus += new KeyboardFocusChangedEventHandler(FeatureSizeLostFocus);
				sizePanel.Children.Add(yBox);
				mainPanel.Children.Add(sizePanel);
			}
		}

		private void DescriptionButtonClick(object sender, RoutedEventArgs e) {
			DescriptionSymbolButton bt = (DescriptionSymbolButton)sender;
			OnDescriptionSelected(bt.SymbolCode, Column);
			mainPopup.IsOpen = false;
		}

		private void FeatureSizeLostFocus(object sender, RoutedEventArgs e) {
			if (xBox == null || yBox == null) {
				return;
			}
			double x;
			if (!double.TryParse(xBox.Text, out x)) {
				x = featureSize.Width;
			}
			double y;
			if (!double.TryParse(yBox.Text, out y)) {
				y = featureSize.Height;
			}
			if (xBox.Text == "") {
				x = 0;
			}
			if (yBox.Text == "") {
				y = 0;
			}
			if (x == featureSize.Width && y == featureSize.Height) {
				SetFeatureSize(x, y);
				return;
			}
			SetFeatureSize(x, y);
			OnFeatureSizeSet(x, y);
		}

		private void OnDescriptionSelected(string code, int column) {
			if (DescriptionSelected != null) {
				DescriptionSelected.Invoke(code, column);
			}
		}

		private void OnFeatureSizeSet(double x, double y) {
			if (FeatureSizeSet != null) {
				FeatureSizeSet.Invoke(x, y);
			}
		}

		public void SetDescription(object description) {
			mainButton.Content = description;
		}

		private void mainButton_Click(object sender, RoutedEventArgs e) {
			if (mainPanel.Children.Count > 0) {
				mainPopup.IsOpen = true;
			}
		}

		private void mainPopup_Opened(object sender, EventArgs e) {
			mainButton.IsHitTestVisible = false;
		}

		private void mainPopup_Closed(object sender, EventArgs e) {
			mainButton.IsHitTestVisible = true;
		}

	}

	public class DescriptionSymbolButton : Button {

		public int Column;
		public string SymbolCode;

	}

}
