﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Windows;

namespace OPlanner {

	public static class OPlannerHelper {

		public static int CompareOBaseObjects(OBaseObject x, OBaseObject y) {
			Match match;
			int pos;
			match = Regex.Match(x.ObjectCode, "0-9");
			pos = match.Index;
			if (pos < 0) {
				return x.ObjectCode.CompareTo(y.ObjectCode);
			}
			string xPrefix;
			string xNumber;
			xPrefix = x.ObjectCode.Substring(0, pos);
			xNumber = x.ObjectCode.Substring(pos);
			int xNum;
			if (!int.TryParse(xNumber, out xNum)) {
				return x.ObjectCode.CompareTo(y.ObjectCode);
			}
			match = Regex.Match(y.ObjectCode, "0-9");
			pos = match.Index;
			if (pos < 0) {
				return x.ObjectCode.CompareTo(y.ObjectCode);
			}
			string yPrefix;
			string yNumber;
			yPrefix = y.ObjectCode.Substring(0, pos);
			yNumber = y.ObjectCode.Substring(pos);
			int yNum;
			if (!int.TryParse(yNumber, out yNum)) {
				return x.ObjectCode.CompareTo(y.ObjectCode);
			}
			if (xPrefix != yPrefix) {
				return x.ObjectCode.CompareTo(y.ObjectCode);
			}
			return xNum.CompareTo(yNum);
		}

		public static double MillimetresToPixels(double val) {
			return val * 0.1 / 2.54 * 96.0;
		}

		public static double PixelsToMillimetres(double val) {
			return val * 25.4 / 96.0;
		}

		public static string GetAbsolutePath(string basePath, string relative) {
			Uri uri = new Uri(new Uri(basePath),  Uri.UnescapeDataString(relative));
			return Uri.UnescapeDataString(uri.AbsolutePath);
		}

		public static string GetRelativePath(string basePath, string absolute) {
			Uri uri = new Uri(absolute);
			Uri baseUri = new Uri(basePath);
			return baseUri.MakeRelativeUri(uri).ToString();
		}

		public static Window MainWindow {
			get {
				return App.Current.MainWindow;
			}
		}

	}

}
